/*------------------------------------------------------------------------------*
 * File Name: PBPageList.c														*
 * Creation: 																	*
 * Purpose: A Control base class for showing a list of pages 					*
 * Copyright (c) Originlab Corp., 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Jasmine 11/29/05 QA70-8352 v8.0341 MODIFICATION_FINDCLASS					*
 *	CPY 12/2/05 rename from .h to .c and made relavent changes					*
 * Jasmine 12/25/06 SHOW_PAGE_OR_LAYER											*
 * Folger 07/13/07 ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE				*
 * Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE						*
 * Folger 11/07/07 COLUMN_HEADING_LOCALIZE										*
 * Kyle 07/15/08 QA80-11840 OVER_LOAD_FUNCTION_GETDEFAULTSHOW					*
 * Jasmine 02/21/10 QA81-14826-P4 CHECK_MENU_MISSING_IN_PAGE_BROWSER			*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include "DialogEx.h"
#include "PBListBase.h"

enum {PEPAGE_LONGNAME, PEPAGE_SHORTNAME, PEPAGE_TYPE,PEPAGE_VIEW, PEPAGE_SIZE,PEPAGE_TOTAL_COLS};
//------ Folger 11/07/07 COLUMN_HEADING_LOCALIZE
//#define PAGE_LIST_COL_HEADER		_L("Long Name|Short Name|Type|View|Size")
#ifndef _CAT
#define _CAT "PEPages"
#endif
#define PAGE_LIST_COL_HEADER		_LC("Long Name|Short Name|Type|View|Size", _CAT)
//------ End COLUMN_HEADING_LOCALIZE

//class PBPageList : public BrowserBaseClass	///Jasmine 11/29/05 QA70-8352 v8.0341 MODIFICATION_FINDCLASS
class OC_REGISTERED PBPageList : public PBListBase
{
	PBPageList()
	{
		//------ Folger 11/07/07 COLUMN_HEADING_LOCALIZE
		//GetFormatStrAsArray(PAGE_LIST_COL_HEADER, m_vsColHeadings, "PEPages");
		GetFormatStrAsArray(PAGE_LIST_COL_HEADER, m_vsColHeadings, _CAT);
		//------ End COLUMN_HEADING_LOCALIZE
	}
	~PBPageList()
	{
	}	
public:

	///Kyle 07/15/08 QA80-11840 OVER_LOAD_FUNCTION_GETDEFAULTSHOW
	virtual int	GetDefaultShow( Layer& lay, GridTreeControl* pGridTree, LPCSTR lpcszDefaultShow = NULL )
	{
		int nRow =- 1;
		string strDefaultShow( lpcszDefaultShow );
		if( strDefaultShow.IsEmpty() )
		{
			Folder fld = Project.ActiveFolder();
			strDefaultShow = fld.GetPath();
		}
		strDefaultShow.TrimLeft('/');
		strDefaultShow.TrimRight('/');
		vector<string> vs;
		strDefaultShow.GetTokens(vs, '/');
		for( int ii = 0; ii < vs.GetSize(); ii++)
		{
			int nLevel = -1;
			while( nLevel != ii )
			{
				nRow = pGridTree->FindRow( vs[ii], 0, false, true, nRow+1 );
				nLevel = ( (-1 == nRow)? ii : pGridTree->GetLevel( nRow ) );
			}
		}
		return nRow;
	}
	///End OVER_LOAD_FUNCTION_GETDEFAULTSHOW

	///Jasmine 02/21/10 QA81-14826-P4 CHECK_MENU_MISSING_IN_PAGE_BROWSER
	virtual BOOL SetShowColumns(const vector<uint>& vnShowColumns = NULL)
	{
		vector<byte> vbShowCols;
		vbShowCols.SetSize(PEPAGE_TOTAL_COLS);
		vbShowCols = 1;
		
		m_vnShowColumns.Data(PEPAGE_LONGNAME, PEPAGE_SIZE);
		if(vnShowColumns)
			m_vnShowColumns = vnShowColumns;		
		int nSize = m_vnShowColumns.GetSize();
		for(int ii = 0; ii < nSize; ii++)
		{
			int nIndex = m_vnShowColumns[ii];
			if(PEPAGE_TOTAL_COLS > nIndex)
				vbShowCols[nIndex] = 0;
		}
		vbShowCols[PEPAGE_SIZE] = 1;
		LoadHideCols(m_strDlgName, GetRuntimeClass(), &vbShowCols);
		return true;
	}
	///End CHECK_MENU_MISSING_IN_PAGE_BROWSER
	
	//-----Folger 07/13/07 ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE
	//void Init(int nID, WndContainer& dlg, LPCSTR lpcszDlgName )
	void Init(int nID, WndContainer& dlg, LPCSTR lpcszDlgName, int nShowItemType )
	//-----Folger 07/13/07 ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE
	{
		//-----Folger 07/13/07 ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE
		//PBListBase::Init(nID, dlg, lpcszDlgName);
		PBListBase::Init(nID, dlg, lpcszDlgName, nShowItemType);
		//-----End ADD_SHOW_ITEM_TYPE_TO_SPECIFY_BROWSE_PAGE_TYPE
		
		m_PBBType = ITEM_IS_PAGE;
	}
	virtual int GetPBListType()
	{
		return PB_BROWSER_PAGE_LIST;
	}
	virtual int GetItemType(int nRow)
	{
		string strType;
		strType =GetCell(nRow,PEPAGE_TYPE);
		if(strType.IsEmpty())
			return ITEM_IS_NULL;
		
		if(strType.CompareNoCase(_L("Folder")) == 0)
			return ITEM_IS_FOLDER;
			
		return ITEM_IS_PAGE;
	}
	virtual void GetBrowserSupportTypeList(vector<int> &vnList)
	{
		vector<int> vnTypeLit = {EXIST_WKS, EXIST_GRAPH, EXIST_MATRIX, EXIST_LAYOUT, EXIST_NOTES, EXIST_NONE};
		vnList = vnTypeLit;
	}
	///Sophy CLEAN_CODE_PBLIST_CONTROL
	/*
	///Jasmine 12/25/06 SHOW_PAGE_OR_LAYER
	virtual bool UpdateList(TreeNode trNode, int nShowItemType = 0)
	{
		if(!trNode.IsValid())
			return false;
		
		string strPath;
		trNode.GetAttribute(STR_PATH_ATTRIB, strPath);	
		
		Folder fldr(strPath);		
		//----- Iris 12/22/2006 CHOOSE_PAGE_IN_LEFT_SHOULD_SHOW_LAYER_IN_RIGHT_PANEL
			//return UpdateList(fldr , nShowItemType);
		if(fldr)
			return UpdateList(fldr , nShowItemType);
		
		string 	strName;
		trNode.GetAttribute(STR_LABEL_ATTRIB, strName);
		Page	pg(strName);
		if(!pg)
		{
			string strPage;
			okutil_get_book_sheet_names(strName, &strPage, &strName); 
			Page pgTemp(strPage);
			pg = pgTemp;
		}
		if(pg)
			return UpdateList(pg, nShowItemType);
		
		return false;
		//-----
	}
	///End SHOW_PAGE_OR_LAYER
	*/
	//virtual
	bool	GetItems( TreeNode& trNode, 
					vector<string>& vsItems, vector<int>& vnPageType, 
					vector<DWORD>& vdwStatus,//vector<bool>& vbHideGray, ///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
					int nShowItemType = 0,
					bool bIncludeShortcut = false)	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	{
		if( !trNode.IsValid() )
			return false;
		
		string strPath;
		trNode.GetAttribute(STR_PATH_ATTRIB, strPath);	
		
		Folder fldr(strPath);		
		if(fldr)
		{
			bool bRet = GetItems( fldr, 
								vsItems, vnPageType, vdwStatus, 
								nShowItemType, false,
								bIncludeShortcut);	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
			return bRet;
		}

		string 	strName;
		trNode.GetAttribute(STR_LABEL_ATTRIB, strName);
		Page	pg(strName);
		if(!pg)
		{
			string strPage;
			okutil_get_book_sheet_names(strName, &strPage, &strName); 
			Page pgTemp(strPage);
			pg = pgTemp;
		}
		if(pg)
		{
			///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
			int nRet = strPath.ReverseFind('/');
			if(nRet > -1)
				strPath = strPath.Left(nRet);
			Folder fldParent(strPath);
			return GetItems( pg, vsItems, vnPageType, vdwStatus, nShowItemType, fldParent);
			///End BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
		}
		
		return false;
	}
	///end Sophy CLEAN_CODE_PBLIST_CONTROL
protected:
	virtual string GetRuntimeClass()
	{
		return "PBPageList";
	}
	//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	//virtual bool AddItems(PageBase &pb)
	virtual bool AddItems(PageBase &pb, 
						vector<string> &vsRows, vector<int> &vnPageType, 
						vector<DWORD>& vdwStatus,//vector<bool> &vbHideGray)	///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
						const Folder& fldParent = NULL)	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	{
		//if(pb && PageVisible(pb))
		if(pb)
		{
			//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
			//m_flx.AddItem(MakeRow(pb));
			////SetCellIcon(m_flx.Rows - 1, 0, GetDisplayId(pb.GetType()), MODULE_ORIGIN);//TD 3-30-04
			//SetCellIcon(m_flx.Rows - 1, 0, get_page_display_id(pb.GetType()), MODULE_ORIGIN);//TD 3-30-04
			//if(pb.GetShow() == PAGE_HIDDEN)
				//SetHideGray(m_flx.	Rows-1, 0);
			vsRows.Add(MakeRow(pb));
			vnPageType.Add(pb.GetType());
			DWORD dwStatus = pb.GetShow() == PAGE_HIDDEN? PAGE_STATUS_HIDDEN : 0;
			///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
			if(fldParent)
			{
				DWORD dw = pb.GetStatus(fldParent);
				if(dw & PBFS_SHORTCUT)
					dwStatus |= PAGE_STATUS_SHORTCUT;
			}
			///End BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
			vdwStatus.Add(dwStatus);
			//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
			return true;
		}
		return false;
	}
	virtual string GetSeletedItemName(int nRow, bool bIncludeFolder = false)
	{			
		string strSeletedName;
		//if(GetItemType(nRow) != ITEM_IS_PAGE || nRow == 0)
		if((GetItemType(nRow) != ITEM_IS_PAGE && !bIncludeFolder) || nRow == 0)
			return "";
		
		string strShortName = GetCell(flexcpText, nRow, PEPAGE_SHORTNAME);
		string strLongName = GetCell(flexcpText, nRow, PEPAGE_LONGNAME);
		if(strShortName.IsEmpty())
			strShortName = strLongName.MakeValidCName();
		
		strSeletedName = strShortName;

		return strSeletedName;
	}
	virtual string MakeCol(OriginObject &obj, int nColType)
	{
		/// TD 8-3-06 QA70-8843 DOWNCAST_BUG
		//PageBase page(obj);
		PageBase page;
		page = obj;
		/// end DOWNCAST_BUG

		string strTemp;
		switch(nColType)
		{
		case PEPAGE_SHORTNAME:
			return page.GetName();
		case PEPAGE_LONGNAME: // long name, if label empty, use tagName
			return page_get_display_name(page);
		case PEPAGE_TYPE:
			return getPageTypeName(page.GetType());
		case PEPAGE_VIEW:
			return GetPageShowState(page.GetShow());
		case PEPAGE_SIZE:
			return getPageSize(page);
		default:
			break;
		}
		
		return strTemp;// return empty
	}
	virtual string MakeFolderCol(Folder &fld, int nColType)
	{
		string strTemp;
		switch(nColType)
		{
		case PEPAGE_LONGNAME:
			return fld.GetName();
		case PEPAGE_TYPE:
			return _L("Folder");
		default:
			strTemp = "";
			break;
		}
		return strTemp;
	}
private:
	string getPageTypeName(int nPageType)
	{
		switch(nPageType)
		{
		case EXIST_GRAPH:
			return _L("GraphPage");
		case EXIST_WKS:
			return _L("WorksheetPage");
		case EXIST_NOTES:
			return _L("Note");
		case EXIST_EXTERN_WKS:
			return _L("WorksheetPage");
		case EXIST_MATRIX:
			return _L("MatrixPage");
		case EXIST_LAYOUT:
			return _L("LayoutPage");
		default:
			break:
		};
		return _L("Folder");
	}	
	string getPageSize(const PageBase &pb)
	{
		if(!pb)
			return -1;
		
		PageSystemInfo PgInfo;
		bool bb = pb.GetPageSystemInfo(&PgInfo);
		
		int nSize = PgInfo.nSize;

		return (string) nSize;
	}
private:
};

